# 📖 ספר המתכונים שלי - Web Clipper

תוסף כרום לשמירת מתכונים מכל אתר ישירות לספר המתכונים שלך!

## ✨ תכונות

- **ממשק מודרני** בעיצוב תואם לאתר (גרדיאנט קורל #ff6b6b → #ff8c42)
- **תמיכה בעברית** עם כיוון RTL מלא
- **אנימציות חלקות** (אפקט נצנוץ בכותרת, מעברים חלקים)
- **חילוץ מתכונים חכם** - משתמש ב-API הקיים של האתר
- **מיון אוטומטי לקטגוריות** על בסיס המסווג הקיים
- **זיהוי התחברות** עם הנחיות ידידותיות
- **משוב הצלחה** עם כפתור "צפה במתכון" לאחר השמירה

## 📁 מבנה הקבצים

```
chrome-extension/
├── manifest.json       # הגדרות התוסף (Manifest V3)
├── popup.html          # ממשק המשתמש
├── popup.js            # לוגיקת התוסף
├── icons/
│   ├── icon.svg        # אייקון מקור
│   ├── icon16.png      # אייקון סרגל כלים
│   ├── icon32.png      # רשימת תוספים
│   ├── icon48.png      # דף תוספים
│   └── icon128.png     # Chrome Web Store
├── generate_icons.py   # סקריפט יצירת אייקונים
└── README.md           # הקובץ הזה
```

## 🚀 התקנה

### שלב 1: יצירת אייקונים (אם צריך)
האייקונים כבר נוצרו, אבל אם צריך ליצור מחדש:

```bash
cd chrome-extension
python generate_icons.py
```

### שלב 2: התקנת התוסף בכרום

1. פתח את Chrome ועבור ל: `chrome://extensions/`
2. הפעל את **מצב מפתחים** (Developer mode) בפינה הימנית העליונה
3. לחץ על **טעינת תוסף לא ארוז** (Load unpacked)
4. בחר את תיקיית `chrome-extension`
5. התוסף יופיע בסרגל הכלים! 🎉

## 📖 שימוש

1. **גלוש** לדף מתכון בכל אתר (פייסבוק, טיקטוק, בלוגים וכו')
2. **לחץ** על אייקון התוסף בסרגל הכלים
3. **לחץ** על כפתור **"שמור לספר המתכונים"**
4. **המתכון נשמר** אוטומטית עם חילוץ כותרת, תיאור ותמונה!

## ⚙️ הגדרות

### שינוי כתובת ה-API

בקובץ `popup.js`, שנה את `API_BASE_URL`:

```javascript
const CONFIG = {
  // Production - הכתובת הראשית
  API_BASE_URL: 'https://myrecipebook.net',
  
  // Development - לפיתוח מקומי (הסר הערה לשימוש)
  // API_BASE_URL: 'http://localhost:5000',
};
```

## 🎨 עיצוב

הצבעים בתוסף מותאמים לעיצוב ספר המתכונים:

| צבע | קוד | שימוש |
|-----|-----|-------|
| Primary | `#ff6b6b` | צבע ראשי - קורל |
| Accent | `#ff8c42` | צבע משני - כתום |
| Success | `#26de81` | הצלחה - ירוק |
| Cream | `#faf8f6` | רקע |

## 🔧 פתרון בעיות

### "יש להתחבר כדי לשמור מתכונים"
וודא שאתה מחובר לחשבון בספר המתכונים. לחץ על כפתור ההתחברות בתוסף.

### "לא ניתן לשמור דף זה"
הדף הנוכחי הוא דף מערכת של Chrome (chrome://) שלא ניתן לשמור.

### "שגיאה בחילוץ המתכון"
ייתכן שהאתר חוסם גישה אוטומטית. נסה מאתר אחר או הוסף את המתכון ידנית דרך האתר.

## 🔒 הרשאות

התוסף דורש את ההרשאות הבאות:
- `activeTab` - גישה לכרטיסייה הנוכחית (כותרת וכתובת URL)
- `storage` - שמירת הגדרות מקומיות
- גישה לשרת ספר המתכונים לשליחת בקשות API

## 📝 רישיון

נבנה עם ❤️ עבור ספר המתכונים שלי

---

### סיכום מהיר

| פעולה | תוצאה |
|-------|-------|
| לחיצה על אייקון התוסף | פתיחת חלון שמירה |
| לחיצה על "שמור לספר המתכונים" | שליחת הדף ל-API וחילוץ המתכון |
| הצלחה | המתכון נשמר + כפתור לצפייה |
| שגיאה | הודעת שגיאה עם הסבר |
